package com.cusc.nirvana.user.auth.identification.service;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;

/**
 * Description: 登录service
 * <br />
 * CreateDate 2021-11-02 20:25:19
 *
 * @author yuyi
 **/
public interface ILoginService {

    /**
     * Description: C端用户手机号登录
     * <br />
     * CreateDate 2022-04-15 19:53:41
     *
     * @author huzl
     **/
    Response<Oauth2Token> ciamMobileLogin(MobileLoginReq bean);

    /**
     * Description: C端用户手机号登录小鹏
     * <br />
     * CreateDate 2022-04-15 19:53:41
     *
     * @author huzl
     **/
    Response<Oauth2Token> ciamMobileLoginXP(MobileLoginReq bean);

    /**
     * Description: 手机号登录
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Oauth2Token> mobileLogin(MobileLoginReq bean);

    /**
     * Description: 发送短信验证码
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Boolean> sendSmsCaptcha(MobileLoginReq bean);

    /**
     * Description: 检查短信验证码
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Boolean> checkSmsCaptcha(MobileLoginReq bean);

    /**
     * Description: 用户名登录
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Oauth2Token> userNameLogin(UserNameLoginReq bean);

}
