package com.cusc.nirvana.user.auth.identification.login;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.auth.identification.service.ILoginService;
import com.cusc.nirvana.user.auth.identification.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/login")
public class LoginController {

    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);

    @Autowired
    ILoginService loginService;

    @PostMapping("/sendSmsCaptcha")
    @ApiOperation(value = "发送短信验证码", notes = "发送短信验证码")
    public Response<Boolean> sendSmsCaptcha(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getPhone()) || bean.getCaptchaExpire() == null) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }

        //图形验证码校验
        if (bean.isCheckCaptchaImg() && CuscStringUtils.isEmpty(bean.getCaptchaImage()) && CuscStringUtils.isEmpty(
                bean.getRequestId())) {
            return Response.createError(ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getMsg(),
                    ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getCode());
        }

        //其他参数配置
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());

        log.info("sendSmsCaptcha request url: /user-auth/login/sendSmsCaptcha , param: {}",
                JSON.toJSON(bean.getPhone()));
        return loginService.sendSmsCaptcha(bean);
    }

    @PostMapping("/mobile")
    @ApiOperation(value = "手机号登录", notes = "手机号登录")
    public Response<Oauth2Token> mobileLogin(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getPhone()) || CuscStringUtils.isEmpty(bean.getCaptcha())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        log.info("mobileLogin request url: /user-auth/login/mobile , phone: {} , captcha: {}",
                bean.getPhone(), bean.getCaptcha().substring(1));
        return loginService.mobileLogin(bean);
    }

    @PostMapping("/username")
    @ApiOperation(value = "用户名登录", notes = "用户名登录")
    public Response<Oauth2Token> userNameLogin(@RequestBody UserNameLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getUserName()) || CuscStringUtils.isEmpty(
                bean.getPassword())) {
            return Response.createError(ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getMsg(),
                    ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        log.info("userNameLogin request url: /user-auth/login/username, param : {}", JSON.toJSONString(bean));
        return loginService.userNameLogin(bean);
    }
}
