package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.service.ILoginService;
import com.cusc.nirvana.user.auth.identification.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/ciam/login")
public class CiamLoginController {

    @Autowired
    ILoginService loginService;

    @PostMapping("/mobile")
    @ApiOperation(value = "手机号登录", notes = "手机号登录")
    public Response<Oauth2Token> mobileLogin(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getPhone()) || CuscStringUtils.isEmpty(bean.getCaptcha())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        log.info("mobileLogin request url: /user-auth/ciam/login/mobileLogin , phone: {} , captcha: {}",
                bean.getPhone(), bean.getCaptcha().substring(1));
        return loginService.ciamMobileLogin(bean);
    }


    /**
     * 小鹏用户登录
     * @param bean
     * @return
     */
    @PostMapping("/mobileXP")
    @ApiOperation(value = "手机号登录", notes = "手机号登录")
    public Response<Oauth2Token> mobileLoginXP(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getPhone()) ) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        log.info("mobileLoginXP request url: /user-auth/ciam/login/mobileLogin , phone: {} ",
                bean.getPhone());
        return loginService.ciamMobileLoginXP(bean);
    }
}
