package com.cusc.nirvana.user.auth.common.service;

import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.service.IApplicationService;
import com.cusc.nirvana.user.exception.CuscUserException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Description: 异步执行service
 * <br />
 * CreateDate 2021-11-02 20:25:49
 *
 * @author yuyi
 **/
@Service
@Slf4j
public class AppConfigService {

    @Autowired
    private IApplicationService applicationService;

    /**
     * Description: 通过应用编码获取应用配置信息
     * <br />
     * CreateDate 2022-01-27 15:25:17
     *
     * @author yuyi
     **/
    public ApplicationDTO getAppConfigByCode(String appCode) {
        ApplicationDTO appResp = applicationService.getCacheByCode(appCode);
        if(appResp != null){
            return appResp;
        }
        throw new CuscUserException(ResponseCode.APP_CONFIG_NOT_NULL.getCode() + "",
                ResponseCode.APP_CONFIG_NOT_NULL.getMsg());
    }
}
