package com.cusc.nirvana.user.auth.common.constants;

/**
 * Description: 响应码
 * <br />
 * CreateDate 2021-11-02 19:52:36
 *
 * @author yuyi
 **/
public enum ResponseCode {
    INVALID_DATA(1001, "数据校验不通过"),
    SYS_BUSY(1002, "服务调用失败"),
    SERVICE_NOT_FOUND(1003, "服务不存在"),
    TP_SYS_BUSY(1004, "第三方服务调用失败"),
    JSON_FORMAT_ERROR(1005, "参数格式错误"),
    REQ_TOO_MANY_TIMES(1007, "请求过于频繁，请稍后再试!"),
    NO_DATA_AUTH(1008, "请求过于频繁，请稍后再试!"),
    REDIS_OPT_FAIL(1009, "redis操作失败，请稍后再试！"),
    PARAMETER_NULL(1010, "请求参数不能为空！"),

    UNAUTHORIZED(1050, "鉴权失败：未授权"),
    AUTHENTICATION_FAIL(1051, "鉴权失败：无效的令牌或请求"),
    //token获取失败,访问redis失败
    TOKEN_AUTHENTICATION_FAIL(1052, "token鉴权失败"),
    RESOURCE_NOT_REPORTED(1053, "请求的资源未登记"),
    WHITE_LIST_AUTHENTICATION_FAIL(1055, "鉴权失败：无效的请求或应用未登记"),

    TOKEN_INVALID(1101, "token已过期"),
    //已在其他终端登录，强制下线
    REPEAT_LOGIN_KICK_OUT(1102, "token已踢出"),
    //用户冻结，强制下线
    USER_FROZEN_KICK_OUT(1103, "token已踢出"),
    //权限变动等原因，强制下线
    AUTH_CHANGE_KICK_OUT(1104, "token已踢出"),
    CLIENT_ID_INVALID(1110, "clientId无效"),
    AES_SECRET_KEY_FAIL(1111, "AES生成秘钥失败"),
    SMS_CREATE_CAPTCHA_FAIL(1112, "生成短信验证码失败"),
    SMS_GET_CAPTCHA_FAIL(1113, "获取短信验证码失败"),
    SMS_CAPTCHA_INVALID(1114, "短信验证码无效！"),
    SMS_CAPTCHA_INTERVAL_FAIL(1115, "短信验证码获取太频繁，请稍后重试！"),
    SMS_CAPTCHA_SEND_FAIL(1116, "短信发送失败，请稍后重试！"),
    SMS_SEND_ERROR(1117, "短信发送失败，内部错误"),
    SMS_TOTAL_LIMIT_OVERRUN(1118, "发送短信超过当天发送的最大限制"),
    SMS_INTERVAL_LIMIT_OVERRUN(1119, "短信发送失败，发送间隔限制时间内重复发送"),

    LOGIN_USER_NAME_PASSWORD_INVALID(1201,"用户名或密码错误"),
    LOGIN_PHONE_PASSWORD_NOT_NULL(1202,"手机号不能为空"),
    LOGIN_NAME_INVALID(1203,"您输入的帐号不存在，请重新输入！"),
    LOGIN_NAME_STOP(1204,"您输入的帐号已被停用，请与管理员联系！"),
    LOGIN_NAME_NOT_NULL(1205,"请输入正确的账号！"),
    TOEKN_CREATE_FAIL(1206,"token生成失败"),
    LOGOUT_FAIL(1207,"退出失败，系统异常！"),
    KICK_OUT_FAIL(1208,"踢出失败，系统异常！"),
    SYSTEM_OPT_FAIL(1209,"系统异常，请与管理员联系！"),
    CAPTCHA_IMAGGE_NOT_NULL(1210,"图形验证码不能为空"),
    CAPTCHA_IMAGGE_CHECK_FAIL(1211,"图形验证码验证失败"),
    SMS_SEND_CONFIG_NOT_NULL(1212,"短信发送配置不能为空"),
    APP_CONFIG_NOT_NULL(1213,"应用配置信息不能为空"),
    REQUEST_ID_SECRET_KEY_INVALID(1214,"请求id对应的密钥无效"),
    APPLICATION_TENANT_REQUIRED(1215,"应用id和租户编号不能为空"),
    USER_NAME_PWD_FAIL_LOCK(1216,"账号密码错误次数过多，账号已锁定，请稍后再试！"),
    LOGIN_PHONE_INVALID(1217,"您输入的手机号不存在，请重新输入！"),
    ;

    private Integer code;
    private String msg;

    ResponseCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
