package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 用户资源关系(UserResource) client
 *
 * @author yuy336
 * @since 2022-01-19 13:41:36
 */
@Component
public class UserResourceClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<UserResourceDTO>> queryByList(UserResourceDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userResource/queryByList", bean,
                UserResourceDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(UserResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userResource/add", bean, Response.class);
    }
}
