package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: 角色资源api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class RoleResourceClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 用户资源信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response add(RoleResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleResource/add", bean,
                Response.class);
    }

    /**
     * 新增角色与资源的关系（先删除后新增）
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response addBatchResource(RoleResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleResource/addBatchResource", bean,
                Response.class);
    }

    /**
     * 通过资源批量删除角色与资源的关系
     *
     * @param bean 实体
     * @return 删除结果
     */
    public Response deleteBatchRole(RoleResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleResource/deleteBatchRole", bean,
                Response.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<RoleResourceDTO>> queryByList(@RequestBody RoleResourceDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/roleResource/queryByList", bean, RoleResourceDTO.class);
    }

}
