package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: 角色api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class RoleClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 新增角色(add)
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<RoleDTO> add(RoleDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role/add",
                bean,
                RoleDTO.class);
    }

    /**
     * Description: 更新角色信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response<RoleDTO> update(RoleDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role/update",
                bean,
                RoleDTO.class);
    }

    /**
     * Description: 删除角色信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response delete(RoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/role/delete", bean, Response.class);
    }

    /**
     * Description: 冻结角色信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response frozen(RoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/role/frozen", bean, Response.class);
    }

    /**
     * Description: 解冻角色信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response unfreeze(RoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/role/unfreeze", bean,
                Response.class);
    }

    /**
     * Description:通过id查询角色详情
     * <br />
     * CreateDate 2021-10-25 15:48:01
     *
     * @author yuyi
     **/
    public Response<RoleDTO> get(RoleDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role/get",
                bean,
                RoleDTO.class);
    }

    /**
     * Description: 通过uuid查询角色详情
     * <br />
     * CreateDate 2021-10-25 15:48:29
     *
     * @author yuyi
     **/
    public Response<RoleDTO> getByUuid(RoleDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role/getByUuid",
                bean,
                RoleDTO.class);
    }

    /**
     * Description: 通过uuid集合查询角色详情
     * <br />
     * CreateDate 2021-10-25 15:49:25
     *
     * @author yuyi
     **/
    public Response<List<RoleSimpleDTO>> getByUuids(RoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/role/getByUuids", bean,
                RoleSimpleDTO.class);
    }

    /**
     * Description: 分页查询角色信息(page)
     * <br />
     * CreateDate 2021-10-25 15:50:00
     *
     * @author yuyi
     **/
    public Response<PageResult<RoleDTO>> page(RoleDTO bean) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/role/page", bean,
                RoleDTO.class);
    }

    /**
     * Description: 查询角色所有信息
     * <br />
     * CreateDate 2021-10-25 15:51:50
     *
     * @author yuyi
     **/
    public Response<List<RoleSimpleDTO>> query(RoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role/query",
                bean,
                RoleSimpleDTO.class);
    }


    /**
     * Description: 通过用户id查询角色信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<List<RoleDTO>> queryRoleByUserId(@RequestBody UserRoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/role/queryRoleByUserId", bean,
                RoleDTO.class);
    }

    /**
     * Description: 通过角色名称查询角色信息
     * <br />
     * CreateDate 2021-11-01 19:17:17
     *
     * @author yuyi
     **/
    public Response<List<RoleSimpleDTO>> queryRoleByName(RoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/role/queryRoleByName", bean,
                RoleSimpleDTO.class);
    }

    /**
     * Description: 通过用户id查询是否脱敏   false 脱敏，  true 不脱敏
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response<Boolean> queryHideSensitiveByUserId(UserRoleDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/role"
                + "/queryHideSensitiveByUserId", bean, Boolean.class);
    }
}
