package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * (ResourceTempalte) client
 *
 * @author yuy336
 * @since 2022-01-13 17:10:15
 */
@Component
public class ResourceTempalteClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param resourceTempalte 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<ResourceTempalteDTO>> queryByPage(ResourceTempalteDTO resourceTempalte) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/queryByPage", resourceTempalte,
                ResourceTempalteDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param resourceTempalte 实体
     * @return 单条数据
     */
    public Response<ResourceTempalteDTO> getByUuid(ResourceTempalteDTO resourceTempalte) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/getByUuid",
                resourceTempalte,
                ResourceTempalteDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param resourceTempalte 实体
     * @return 单条数据
     */
    public Response<List<ResourceTempalteDTO>> queryByList(ResourceTempalteDTO resourceTempalte) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/queryByList", resourceTempalte,
                ResourceTempalteDTO.class);
    }

    /**
     * 新增数据
     *
     * @param resourceTempalte 实体
     * @return 新增结果
     */
    public Response add(ResourceTempalteDTO resourceTempalte) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/add",
                resourceTempalte, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param resourceTempalte 实体
     * @return 编辑结果
     */
    public Response update(ResourceTempalteDTO resourceTempalte) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/update",
                resourceTempalte, Response.class);
    }

    /**
     * 删除数据
     *
     * @param resourceTempalte 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(ResourceTempalteDTO resourceTempalte) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resourceTempalte/deleteById",
                resourceTempalte, Response.class);
    }

    /**
     * Description: 通过租户编号和应用id查询资源id集合
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    public Response<List<String>> queryResourceIdList(ResourceTempalteDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL +
                "/resourceTempalte/queryResourceIdList", bean, String.class);
    }
}

