package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 组织机构(Organization) client
 *
 * @author yuy336
 * @since 2022-01-13 17:08:58
 */
@Component
public class OrganizationClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param organization 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<OrganizationDTO>> queryByPage(OrganizationDTO organization) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/organization/queryByPage", organization, OrganizationDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param organization 实体
     * @return 单条数据
     */
    public Response<OrganizationDTO> getByUuid(OrganizationDTO organization) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/organization/getByUuid",
                organization,
                OrganizationDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param organization 实体
     * @return 单条数据
     */
    public Response<List<OrganizationDTO>> queryByList(OrganizationDTO organization) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/organization/queryByList", organization,
                OrganizationDTO.class);
    }

    /**
     * 新增数据
     *
     * @param organization 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response<OrganizationDTO> add(OrganizationDTO organization) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/organization/add", organization,
                OrganizationDTO.class);
    }

    /**
     * 编辑数据
     *
     * @param organization 实体
     * @return 编辑结果
     */
    public Response update(OrganizationDTO organization) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/organization/update", organization,
                Response.class);
    }

    /**
     * 删除数据
     *
     * @param organization 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(OrganizationDTO organization) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/organization/deleteById", organization,
                Response.class);
    }

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response frozen(OrganizationDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/organization/frozen", bean,
                Response.class);
    }

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response unfreeze(OrganizationDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/organization/unfreeze", bean,
                Response.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<OrganizationDTO>> getOrganListByUserId(UserOrganDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/organization/getOrganListByUserId", bean, OrganizationDTO.class);
    }
}

