package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 资源Url api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class EiamUrlClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 通过url 和 应用id 查询url对应的id
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<Long> queryByUrl(EiamUrlDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/resource/url/queryByUrl",
                bean,
                Long.class);
    }

    /**
     * Description: 将用户授权的url写入redis
     * <br />
     * CreateDate 2022-01-25 16:00:00
     *
     * @author yuyi
     **/
    public Response userRoleResUrlToRedis(EiamUrlDTO bean){
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/resource/url/userRoleResUrlToRedis", bean, Response.class);
    }


    /**
     * Description: 将用户授权的url写入redis
     * <br />
     * CreateDate 2022-01-25 16:00:00
     *
     * @author yuyi
     **/
    public Response allUserRelUrlToRedis(EiamUrlDTO bean){
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/resource/url/allUserRelUrlToRedis", bean, Response.class);
    }
}
