package com.cusc.nirvana.user.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.util.concurrent.TimeUnit;

/**
 * Description: 用户的RestTemplate对象
 * <br />
 * CreateDate 2021-10-27 18:52
 *
 * @author yuyi
 **/
@Configuration
@Slf4j
public class RestTemplateUserConfig {

    @Bean(name="restTemplateUser")
    @LoadBalanced
    public RestTemplate restTemplateUser() {
        return getRestTemplateUser();
    }

    public RestTemplate getRestTemplateUser() {
        RestTemplate restTemplate = new RestTemplate(httpRequestFactoryUser());
        return restTemplate;
    }

    private ClientHttpRequestFactory httpRequestFactoryUser() {
        return new HttpComponentsClientHttpRequestFactory(httpClientUser());
    }

    private HttpClient httpClientUser() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        //设置整个连接池最大连接数
        connectionManager.setMaxTotal(200);
        //路由是对maxTotal的细分
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(10000)  //返回数据的超时时间
                .setConnectTimeout(1000) //连接上服务器的超时时间
                .setConnectionRequestTimeout(500) //从连接池中获取连接的超时时间
                .build();
        return HttpClientBuilder.create()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(connectionManager)
                //设置后台线程剔除失效连接
                .evictExpiredConnections()
                .evictIdleConnections(10, TimeUnit.SECONDS)
                .build();
    }
}
