package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import com.cusc.nirvana.user.auth.identification.dto.RandomIdReq;
import com.cusc.nirvana.user.auth.identification.dto.RandomIdResp;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 登录client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class RandomIdClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 获取随机请求id-图形验证码
     * <br />
     * CreateDate 2022-02-07 17:13:49
     *
     * @author yuyi
     **/
    public Response<String> getRequestIdByCaptcha() {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/random/getRequestIdByCaptcha", null,
                String.class);
    }

    /**
     * Description: 获取随机请求id-登录密码加密
     * <br />
     * CreateDate 2022-02-07 17:13:49
     *
     * @author yuyi
     **/
    public Response<RandomIdResp> getRequestIdByLogin(RandomIdReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/random/getRequestIdByLogin", bean,
                RandomIdResp.class);
    }

    /**
     * Description: 获取随机请求id-登录密码加密
     * <br />
     * CreateDate 2022-02-07 17:13:49
     *
     * @author yuyi
     **/
    public Response<String> getContentByRequestId(RandomIdReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/random/getContentByRequestId", bean,
                String.class);
    }

    /**
     * Description: 获取随机请求id-登录密码加密
     * <br />
     * CreateDate 2022-02-07 17:13:49
     *
     * @author yuyi
     **/
    public Response<Boolean> delByRequestId(RandomIdReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/random/delByRequestId", bean, Boolean.class);
    }
}
