package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 登录client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class LoginClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description:
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response<Oauth2Token> mobileLogin(MobileLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/login/mobile", bean,
                Oauth2Token.class);
    }

    /**
     * Description: 发送短信验证码
     * <br />
     * CreateDate 2021-11-05 18:33:55
     *
     * @author yuyi
     **/
    public Response sendSmsCaptcha(MobileLoginReq bean) {
//        return restTemplateUser.postForObject(UserAuthClientConstant.USER_AUTH_URL + "/login/sendSmsCaptcha", bean, Response.class);
        return RestTemplateUtils.postForResponse(restTemplateUser,
                UserAuthClientConstant.USER_AUTH_URL + "/login/sendSmsCaptcha" , bean, Object.class);
    }

     /**
       * @author: jk
       * @description: 用于注册登录验证码
       * @date: 2022/6/14 10:06
       * @version: 1.0
       * @Param:
       * @Return:
       */
    public Response<Object> sendSmsCaptchaNew(MobileLoginReq bean) {
//        return restTemplateUser.postForObject(UserAuthClientConstant.USER_AUTH_URL + "/login/sendSmsCaptchaNew", bean, Response.class);
        return RestTemplateUtils.postForResponse(restTemplateUser,
                UserAuthClientConstant.USER_AUTH_URL + "/login/sendSmsCaptchaNew" , bean, Object.class);

    }

    /**
     * Description: 用户名登录
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response<Oauth2Token> userNameLogin(UserNameLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/login/username", bean,
                Oauth2Token.class);
    }

    /**
     * Description: C端用户手机号登录
     * <br />
     * CreateDate 2022-04-16 18:13:44
     *
     * @author huzl
     **/
    public Response<Oauth2Token> customerMobileLogin(MobileLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/login/customerMobile", bean,
                Oauth2Token.class);
    }
}
