package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateReq;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateResp;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 验证码client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class CaptchaClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 简单图形验证码
     * <br />
     * CreateDate 2022-02-07 17:13:04
     *
     * @author yuyi
     **/
    public Response<CaptchaCreateResp> simpleGraphic(CaptchaCreateReq captchaReq) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/captcha/simpleGraphic", captchaReq,
                CaptchaCreateResp.class);
    }

    /**
     * Description: 验证图形验证码
     * <br />
     * CreateDate 2022-02-07 17:13:04
     *
     * @author yuyi
     **/
    public Response<Boolean> verificationCaptcha(@RequestBody CaptchaVerificationReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/captcha/verificationCaptcha", bean, Boolean.class);
    }

}
