package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 访问鉴权client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component("accessAuthClient")
public class AccessAuthClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 通过token获取用户id信息
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response<AccessTokenHashDTO> getUserByToken(AccessVerifyReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/auth/getUserByToken", bean,
                AccessTokenHashDTO.class);
    }


    /**
     * Description: 请求鉴权
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response<AccessTokenHashDTO> accessVerify(AccessVerifyReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/auth/accessVerify", bean,
                AccessTokenHashDTO.class);
    }

    /**
     * Description: 检查url是否是白名单
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response isWhiteList(AccessVerifyReq bean) {
        return restTemplateUser.postForObject(UserAuthClientConstant.USER_AUTH_URL + "/auth/isWhiteList", bean, Response.class);
    }


}
