/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.config;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateUserConfig {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateUserConfig.class);

    @Bean(name={"restTemplateUser"})
    @LoadBalanced
    public RestTemplate restTemplateUser() {
        return this.getRestTemplateUser();
    }

    public RestTemplate getRestTemplateUser() {
        RestTemplate restTemplate = new RestTemplate(this.httpRequestFactoryUser());
        return restTemplate;
    }

    private ClientHttpRequestFactory httpRequestFactoryUser() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClientUser());
    }

    private HttpClient httpClientUser() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(2000).setConnectionRequestTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

