package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: 用户角色api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class UserRoleClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 用户角色信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response add(@RequestBody UserRoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userRole/add", bean, Response.class);
    }

    /**
     * Description: 用户角色信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response addBatchUserList(@RequestBody UserRoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userRole/addBatchUserList", bean, Response.class);
    }

    /**
     * Description: 批量新增用户角色信息
     * <br />
     * CreateDate 2021-12-01 16:42:13
     *
     * @author yuyi
     **/
    public Response delBatchUser(@RequestBody UserRoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userRole/delBatchUser", bean, Response.class);
    }

    public Response updateByUserId(@RequestBody UserRoleDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userRole/updateByUserId", bean, Response.class);
    }

    public Response<List<UserRoleDTO>> queryListByUserIdList(@RequestBody UserRoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userRole/queryListByUserIdList", bean,
                UserRoleDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<UserRoleDTO>> queryByList(@RequestBody UserRoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userRole/queryByList", bean,
                UserRoleDTO.class);
    }

}
