package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.*;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: 资源api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class ResourceClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 通过角色id查询资源信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<List<ResourceSimpleDTO>> queryResourceByRoleId(RoleResourceDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/queryResourceByRoleId",
                bean,
                ResourceSimpleDTO.class);
    }

    /**
     * Description: 批量新增
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<Integer> addList(ResourceBatchDTO resourceBatch) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/addList",
                resourceBatch, Integer.class);
    }

    /**
     * Description: 通过角色id查询资源信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<List<ResourceSimpleDTO>> query(ResourceDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/query",
                bean,
                ResourceSimpleDTO.class);
    }

    /**
     * Description: 通过用户id查询资源信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<List<ResourceSimpleDTO>> queryResourceByUserId(UserRoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/queryResourceByUserId",
                bean,
                ResourceSimpleDTO.class);
    }

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<ResourceDTO>> queryByPage(ResourceDTO bean) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/queryByPage",
                bean,
                ResourceDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    @PostMapping("/getByUuid")
    @ApiOperation(value = "通过主键查询单条数据", notes = "通过主键查询单条数据")
    public Response<ResourceDTO> getByUuid(ResourceDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/getByUuid",
                bean,
                ResourceDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增数据", notes = "新增数据")
    public Response add(ResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resource/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    @ApiOperation(value = "新增数据", notes = "新增数据")
    public Response update(ResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resource/update", bean,
                Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    @ApiOperation(value = "删除数据", notes = "删除数据")
    public Response<Boolean> deleteById(ResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resource/deleteById", bean,
                Response.class);
    }

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response frozen(ResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resource/frozen", bean,
                Response.class);
    }

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response unfreeze(ResourceDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/resource/unfreeze", bean,
                Response.class);
    }

    /**
     * 生成资源sql
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<List<String>> generateResSql(ResourceDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                EiamClientConstant.USER_EIAM_URL + "/resource/generateResSql",
                bean, String.class);
    }
}
