package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * eiam数据操作历史(DataOperationLog) client
 *
 * @author yuy336
 * @since 2022-01-13 17:08:29
 */
@Component
public class DataOperationLogClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param dataOperationLog 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<DataOperationLogDTO>> queryByPage(DataOperationLogDTO dataOperationLog) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/queryByPage", dataOperationLog, DataOperationLogDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param dataOperationLog 实体
     * @return 单条数据
     */
    public Response<DataOperationLogDTO> getByUuid(DataOperationLogDTO dataOperationLog) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/getByUuid",
                dataOperationLog,
                DataOperationLogDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param dataOperationLog 实体
     * @return 单条数据
     */
    public Response<List<DataOperationLogDTO>> queryByList(DataOperationLogDTO dataOperationLog) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/queryByList", dataOperationLog,
                DataOperationLogDTO.class);
    }

    /**
     * 新增数据
     *
     * @param dataOperationLog 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(DataOperationLogDTO dataOperationLog) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/add", dataOperationLog, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param dataOperationLog 实体
     * @return 编辑结果
     */
    public Response update(DataOperationLogDTO dataOperationLog) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/update", dataOperationLog, Response.class);
    }

    /**
     * 删除数据
     *
     * @param dataOperationLog 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(DataOperationLogDTO dataOperationLog) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/dataOperationLog/deleteById", dataOperationLog, Response.class);
    }
}

