package com.cusc.nirvana.user.ciam.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.ciam.constants.CiamClientConstant;
import com.cusc.nirvana.user.ciam.dto.CiamUserThirdpartyDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

/**
 * 终端用户三方认证(UserThirdparty) client 
 *
 * @author yuy336
 * @since 2022-05-05 19:54:39
 */
@Component
public class UserThirdpartyClient {

    @Resource
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<CiamUserThirdpartyDTO>> queryByPage(CiamUserThirdpartyDTO bean) {
		return RestTemplateUtils.postForResponsePageResult(restTemplateUser, CiamClientConstant.USER_CIAM_URL + "/userThirdparty/queryByPage", bean, CiamUserThirdpartyDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<CiamUserThirdpartyDTO> getByUuid(CiamUserThirdpartyDTO bean) {
		return RestTemplateUtils.postForResponse(restTemplateUser, CiamClientConstant.USER_CIAM_URL +  "/userThirdparty/getByUuid",
               bean,
                CiamUserThirdpartyDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<CiamUserThirdpartyDTO>> queryByList(CiamUserThirdpartyDTO bean) {
		 return RestTemplateUtils.postForResponseList(restTemplateUser, CiamClientConstant.USER_CIAM_URL + "/userThirdparty/queryByList", bean,
                CiamUserThirdpartyDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(CiamUserThirdpartyDTO bean) {
	   return restTemplateUser.postForObject(CiamClientConstant.USER_CIAM_URL + "/userThirdparty/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(CiamUserThirdpartyDTO bean) {
		return restTemplateUser.postForObject(CiamClientConstant.USER_CIAM_URL + "/userThirdparty/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(CiamUserThirdpartyDTO bean) {
		return restTemplateUser.postForObject(CiamClientConstant.USER_CIAM_URL + "/userThirdparty/deleteById", bean, Response.class);
    }
}
