package com.cusc.nirvana.user.ciam.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.ciam.constants.CiamClientConstant;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

/**
 * Description: 用户
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
@RefreshScope
public class CiamUserClient {

    @Resource
    RestTemplate restTemplateUser;

    /**
     * 通过手机号查询用户信息
     *
     * @param bean，phoneNum（必填），tenantNo（非必填，没有时查询es）
     * @return
     */
    public Response<List<CiamUserDTO>> getByPhone(CiamUserDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser,
                CiamClientConstant.USER_CIAM_URL + "/user/ciam/getByPhone", bean,
                CiamUserDTO.class);
    }

    /**
     * 通过手机号和租户编号查询用户信息
     *
     * @param bean phoneNum（必填），tenantNo（必填）
     * @return
     */
    public Response<CiamUserDTO> getByPhoneTenantNo(CiamUserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                CiamClientConstant.USER_CIAM_URL + "/user/ciam/getByPhoneTenantNo", bean,
                CiamUserDTO.class);
    }


    /**
     * 实名注册
     *
     * @param bean
     * @return
     */
    public Response<CiamUserDTO> createUser(CiamUserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser,
                CiamClientConstant.USER_CIAM_URL + "/user/ciam/createUser", bean,
                CiamUserDTO.class);
    }
}
