package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 登录client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
@RefreshScope
public class CiamLoginClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 手机号登录
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response<Oauth2Token> mobileLogin(MobileLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/ciam/login/mobile", bean,
                Oauth2Token.class);
    }
    //郝岩修改  小鹏
    public Response<Oauth2Token> mobileLoginXP(MobileLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/ciam/login/mobileXP", bean,
                Oauth2Token.class);
    }

    public Response<Oauth2Token> userLoginAdd(MobileLoginReq bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, UserAuthClientConstant.USER_AUTH_URL + "/ciam/login/userLoginAdd", bean,
                Oauth2Token.class);
    }

}
