package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 用户组织信息(UserOrgan) client
 *
 * @author yuy336
 * @since 2022-01-13 17:13:16
 */
@Component
public class UserOrganClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param userOrgan 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<UserOrganDTO>> queryByPage(UserOrganDTO userOrgan) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userOrgan/queryByPage", userOrgan, UserOrganDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param userOrgan 实体
     * @return 单条数据
     */
    public Response<UserOrganDTO> getByUuid(UserOrganDTO userOrgan) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userOrgan/getByUuid",
                userOrgan,
                UserOrganDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param userOrgan 实体
     * @return 单条数据
     */
    public Response<List<UserOrganDTO>> queryByList(UserOrganDTO userOrgan) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/userOrgan/queryByList", userOrgan,
                UserOrganDTO.class);
    }

    /**
     * 新增数据
     *
     * @param userOrgan 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(UserOrganDTO userOrgan) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userOrgan/add", userOrgan, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param userOrgan 实体
     * @return 编辑结果
     */
    public Response update(UserOrganDTO userOrgan) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userOrgan/update", userOrgan, Response.class);
    }

    /**
     * 删除数据
     *
     * @param userOrgan 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(UserOrganDTO userOrgan) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/userOrgan/deleteById", userOrgan, Response.class);
    }
}

