package com.cusc.nirvana.user.eiam.client;


import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: 用户api调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
public class UserClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description: 新增用户(add)
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response add(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/add", bean, Response.class);
    }

    /**
     * Description: 更新用户信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response update(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/update", bean, Response.class);
    }

    /**
     * Description: 删除用户信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response delete(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/delete", bean, Response.class);
    }

    /**
     * Description: 冻结用户信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response frozen(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/frozen", bean, Response.class);
    }

    /**
     * Description: 解冻用户信息
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response unfreeze(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/unfreeze", bean, Response.class);
    }

    /**
     * Description:通过id查询用户详情
     * <br />
     * CreateDate 2021-10-25 15:48:01
     *
     * @author yuyi
     **/
    public Response<UserDTO> get(UserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/get",
                bean,
                UserDTO.class);
    }

    /**
     * Description: 通过uuid查询用户详情
     * <br />
     * CreateDate 2021-10-25 15:48:29
     *
     * @author yuyi
     **/
    public Response<UserDTO> getByUuid(UserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/getByUuid",
                bean,
                UserDTO.class);
    }

    /**
     * Description: 通过uuid集合查询用户详情
     * <br />
     * CreateDate 2021-10-25 15:49:25
     *
     * @author yuyi
     **/
    public Response<List<UserSimpleDTO>> getByUuids(UserDTO entity) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/getByUuids",
                entity,
                UserSimpleDTO.class);
    }

    /**
     * Description: 分页查询用户信息(page)
     * <br />
     * CreateDate 2021-10-25 15:50:00
     *
     * @author yuyi
     **/
    public Response<PageResult<UserDTO>> page(UserDTO bean) {
        return RestTemplateUtils.postForResponsePageResult(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/page", bean,
                UserDTO.class);
    }

    /**
     * Description: 查询用户所有信息
     * <br />
     * CreateDate 2021-10-25 15:51:50
     *
     * @author yuyi
     **/
    public Response<List<UserSimpleDTO>> query(UserDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/query", bean,
                UserSimpleDTO.class);
    }

    /**
     * Description: 通过角色id查询用户信息
     * <br />
     * CreateDate 2021-10-25 15:42:15
     *
     * @author yuyi
     **/
    public Response<List<UserDTO>> queryUserByRoleId(UserRoleDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/queryUserByRoleId", bean,
                UserDTO.class);
    }

    /**
     * Description: 通过手机号查询用户详情
     * <br />
     * CreateDate 2021-11-04 20:12:25
     *
     * @author yuyi
     **/
    public Response<UserDTO> getByPhone(UserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/getByPhone", bean,
                UserDTO.class);
    }

    /**
     * Description: 通过登录名查询用户详情
     * <br />
     * CreateDate 2021-11-04 20:12:25
     *
     * @author yuyi
     **/
    public Response<UserDTO> getByUserName(UserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/getByUserName", bean,
                UserDTO.class);
    }

    /**
     * Description: 通过邮箱查询用户详情
     * <br />
     * CreateDate 2021-11-04 20:12:25
     *
     * @author yuyi
     **/
    public Response<UserDTO> getByEmail(UserDTO bean) {
        return RestTemplateUtils.postForResponse(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/user/getByEmail", bean,
                UserDTO.class);
    }

    /**
     * Description: 更换租户管理员账号
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response changeTenantAdmin(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/changeTenantAdmin", bean, Response.class);
    }

    /**
     * Description: 查询用户是否在线
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response<Boolean> getUserOnline(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/getUserOnline", bean, Response.class);
    }

    /**
     * Description: 修改密码
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response changePassword(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/changePassword", bean, Response.class);
    }

    /**
     * Description: 重置密码
     * <br />
     * CreateDate 2021-10-25 15:46:30
     *
     * @author yuyi
     **/
    public Response resetPassword(UserDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/user/resetPassword", bean, Response.class);
    }
}
