package com.cusc.nirvana.user.eiam.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.EiamClientConstant;
import com.cusc.nirvana.user.eiam.dto.RoleTenantDTO;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 角色租户信息表(RoleTenant) client
 *
 * @author yuy336
 * @since 2022-01-17 15:27:05
 */
@Component
public class RoleTenantClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<RoleTenantDTO>> queryByList(RoleTenantDTO bean) {
        return RestTemplateUtils.postForResponseList(restTemplateUser, EiamClientConstant.USER_EIAM_URL + "/roleTenant/queryByList", bean,
                RoleTenantDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(RoleTenantDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleTenant/add", bean, Response.class);
    }

    /**
     * 批量新增角色集合数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response insertBatchRole(RoleTenantDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleTenant/insertBatchRole", bean, Response.class);
    }

    /**
     * 批量新增租户集合
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response insertBatchTenant(RoleTenantDTO bean) {
        return restTemplateUser.postForObject(EiamClientConstant.USER_EIAM_URL + "/roleTenant/insertBatchTenant", bean, Response.class);
    }

}
