package com.cusc.nirvana.user.auth.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.dto.LogoutDTO;
import com.cusc.nirvana.user.auth.constants.UserAuthClientConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 登录client调用
 * <br />
 * CreateDate 2021-10-25 15:36:27
 *
 * @author yuyi
 **/
@Component
@RefreshScope
public class LogoutClient {

    @Autowired
    RestTemplate restTemplateUser;

    /**
     * Description:
     * <br />
     * CreateDate 2021-11-05 18:13:44
     *
     * @author yuyi
     **/
    public Response logout(LogoutDTO logoutDTO) {
        return restTemplateUser.postForObject(UserAuthClientConstant.USER_AUTH_URL + "/logout", logoutDTO, Response.class);
    }
}
