/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.plug.interceptor;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.authentication.plug.util.ThreadLocalUtil;
import com.cusc.nirvana.user.auth.client.AccessAuthClient;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class DevAuthInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevAuthInterceptor.class);
    @Value(value="${spring.application.name}")
    private String serverName;
    @Value(value="${auth.userId: 1}")
    private String userId;
    @Value(value="${auth.appId: 1}")
    private String appId;
    @Value(value="${auth.tenantNo: 1}")
    private String tenantNo;
    @Autowired
    private AccessAuthClient accessAuthClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestUri = request.getRequestURI();
        String token = request.getHeader("Authorization");
        AccessVerifyReq accessVerifyReq = new AccessVerifyReq();
        accessVerifyReq.setServerName(this.serverName);
        accessVerifyReq.setUrl(requestUri);
        Response isWhiteListResp = this.accessAuthClient.isWhiteList(accessVerifyReq);
        if (isWhiteListResp != null && isWhiteListResp.isSuccess().booleanValue() && ((Boolean)isWhiteListResp.getData()).booleanValue()) {
            LOGGER.info("DevAuthInterceptor serverName:{}, url:{}, token:{}. white list", new Object[]{this.serverName, requestUri, token});
        } else {
            LOGGER.info("DevAuthInterceptor url:{},token:{}", (Object)requestUri, (Object)token);
        }
        if (!StringUtils.isEmpty((Object)token)) {
            token = token.replaceAll("bearer ", "");
            accessVerifyReq.setToken(token);
            Response authResp = this.accessAuthClient.getUserByToken(accessVerifyReq);
            if (authResp.isSuccess().booleanValue() && authResp.getData() != null) {
                ThreadLocalUtil.set("userId", ((AccessTokenHashDTO)authResp.getData()).getUserId());
                ThreadLocalUtil.set("appId", ((AccessTokenHashDTO)authResp.getData()).getAppId());
                ThreadLocalUtil.set("tenantNo", ((AccessTokenHashDTO)authResp.getData()).getTenantNo());
                ThreadLocalUtil.set("organId", ((AccessTokenHashDTO)authResp.getData()).getOrganId());
            }
        } else {
            ThreadLocalUtil.set("userId", this.userId);
            ThreadLocalUtil.set("appId", this.appId);
            ThreadLocalUtil.set("tenantNo", this.tenantNo);
        }
        LOGGER.info("DevAuthInterceptor url:{},userId:{},appId:{},tenantNo:{}", new Object[]{requestUri, this.userId, this.appId, this.tenantNo});
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ThreadLocalUtil.removeByKey("userId");
        ThreadLocalUtil.removeByKey("appId");
        ThreadLocalUtil.removeByKey("tenantNo");
        ThreadLocalUtil.removeByKey("organId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            writer.write(json);
        }
    }
}

