/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.plug.interceptor;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.authentication.plug.constants.ResponseCode;
import com.cusc.nirvana.user.auth.authentication.plug.util.ThreadLocalUtil;
import com.cusc.nirvana.user.auth.client.AccessAuthClient;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthInterceptor.class);
    @Value(value="${spring.application.name}")
    private String serverName;
    @Autowired
    private AccessAuthClient accessAuthClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestUri = request.getRequestURI();
        String token = request.getHeader("Authorization");
        AccessVerifyReq accessVerifyReq = new AccessVerifyReq();
        accessVerifyReq.setServerName(this.serverName);
        accessVerifyReq.setUrl(requestUri);
        Response isWhiteListResp = this.accessAuthClient.isWhiteList(accessVerifyReq);
        if (isWhiteListResp != null && isWhiteListResp.isSuccess().booleanValue() && ((Boolean)isWhiteListResp.getData()).booleanValue()) {
            LOGGER.info("AuthInterceptor serverName:{} | url:{} is white list", (Object)this.serverName, (Object)requestUri);
            if (!StringUtils.isEmpty((Object)token)) {
                token = token.replaceAll("bearer ", "");
                accessVerifyReq.setToken(token);
                Response authResp = this.accessAuthClient.getUserByToken(accessVerifyReq);
                if (authResp.isSuccess().booleanValue() && authResp.getData() != null) {
                    ThreadLocalUtil.set("userId", ((AccessTokenHashDTO)authResp.getData()).getUserId());
                    ThreadLocalUtil.set("appId", ((AccessTokenHashDTO)authResp.getData()).getAppId());
                    ThreadLocalUtil.set("tenantNo", ((AccessTokenHashDTO)authResp.getData()).getTenantNo());
                    ThreadLocalUtil.set("organId", ((AccessTokenHashDTO)authResp.getData()).getOrganId());
                }
            }
        } else {
            LOGGER.info("AuthInterceptor url:{},token:{}", (Object)requestUri, (Object)token);
            if (StringUtils.isEmpty((Object)requestUri) || StringUtils.isEmpty((Object)token)) {
                this.returnJson(response, JSON.toJSONString((Object)Response.createError((String)ResponseCode.TOKEN_INVALID.getMsg(), (Integer)ResponseCode.TOKEN_INVALID.getCode())));
                return false;
            }
            token = token.replaceAll("bearer ", "");
            accessVerifyReq.setToken(token);
            Response authResp = this.accessAuthClient.accessVerify(accessVerifyReq);
            if (authResp == null) {
                this.returnJson(response, JSON.toJSONString((Object)Response.createError((String)ResponseCode.TOKEN_INVALID.getMsg(), (Integer)ResponseCode.TOKEN_INVALID.getCode())));
                return false;
            }
            if (!authResp.isSuccess().booleanValue()) {
                this.returnJson(response, JSON.toJSONString((Object)authResp));
                return false;
            }
            ThreadLocalUtil.set("userId", ((AccessTokenHashDTO)authResp.getData()).getUserId());
            ThreadLocalUtil.set("appId", ((AccessTokenHashDTO)authResp.getData()).getAppId());
            ThreadLocalUtil.set("tenantNo", ((AccessTokenHashDTO)authResp.getData()).getTenantNo());
            ThreadLocalUtil.set("organId", ((AccessTokenHashDTO)authResp.getData()).getOrganId());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ThreadLocalUtil.removeByKey("userId");
        ThreadLocalUtil.removeByKey("appId");
        ThreadLocalUtil.removeByKey("tenantNo");
        ThreadLocalUtil.removeByKey("organId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            writer.write(json);
        }
    }
}

