package com.cusc.nirvana.user.auth.authentication.plug.user;

import com.cusc.nirvana.user.auth.authentication.plug.constants.AuthConstant;
import com.cusc.nirvana.user.auth.authentication.plug.util.ThreadLocalUtil;

/**
 * Description: 用户信息获取service
 * <br />
 * CreateDate 2021-11-08 9:41
 *
 * @author yuyi
 **/
public class UserSubjectUtil {
    /**
     * Description: 获取用户id
     * <br />
     * CreateDate 2021-11-08 10:32:53
     *
     * @author yuyi
     **/
    public static String getUserId() {
        Object ret = ThreadLocalUtil.getCache(AuthConstant.USER_ID_NAME);
        if(ret != null){
            return String.valueOf(ret);
        }
        return null;
    }

    /**
     * Description: 获取应用id
     * <br />
     * CreateDate 2021-11-08 10:32:53
     *
     * @author yuyi
     **/
    public static String getAppId() {
        Object ret = ThreadLocalUtil.getCache(AuthConstant.APP_ID_NAME);
        if(ret != null){
            return String.valueOf(ret);
        }
        return null;
    }

    /**
     * Description: 获取当前用户所在的租户
     * <br />
     * CreateDate 2021-11-08 10:32:53
     *
     * @author yuyi
     **/
    public static String getTenantNo() {
        Object ret = ThreadLocalUtil.getCache(AuthConstant.TENANT_NO_NAME);
        if(ret != null){
            return String.valueOf(ret);
        }
        return null;
    }

	/**
	 * 获取组织id
	 * @return
	 */
	public static String getOrganId(){
		Object ret = ThreadLocalUtil.getCache(AuthConstant.ORGAN_ID_NAME);
		if(ret != null){
			return String.valueOf(ret);
		}
		return null;
	}
}
