/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.plug.interceptor;

import com.cusc.nirvana.user.auth.authentication.plug.interceptor.AuthInterceptor;
import com.cusc.nirvana.user.auth.authentication.plug.interceptor.DevAuthInterceptor;
import com.cusc.nirvana.user.auth.authentication.plug.interceptor.SimpleAuthInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfig
implements WebMvcConfigurer {
    @Value(value="#{'${auth.whiteList}'.split(',')}")
    private List<String> whiteList;
    @Value(value="${auth.authModel:1}")
    private int authModel;

    @Bean
    public AuthInterceptor authInterceptor() {
        return new AuthInterceptor();
    }

    @Bean
    public SimpleAuthInterceptor simpleAuthInterceptor() {
        return new SimpleAuthInterceptor();
    }

    @Bean
    public DevAuthInterceptor devAuthInterceptor() {
        return new DevAuthInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration ir;
        switch (this.authModel) {
            case 1: {
                ir = registry.addInterceptor((HandlerInterceptor)this.authInterceptor()).addPathPatterns(new String[]{"/**"});
                break;
            }
            case 2: {
                ir = registry.addInterceptor((HandlerInterceptor)this.simpleAuthInterceptor()).addPathPatterns(new String[]{"/**"});
                break;
            }
            case 3: {
                ir = registry.addInterceptor((HandlerInterceptor)this.devAuthInterceptor()).addPathPatterns(new String[]{"/**"});
                break;
            }
            default: {
                return;
            }
        }
        if (ir != null) {
            ir.excludePathPatterns(this.whiteList).excludePathPatterns(new String[]{"/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**"});
        }
    }
}

