package com.cusc.nirvana.user.auth.authentication.plug.interceptor;

import com.cusc.nirvana.user.auth.authentication.plug.constants.AuthConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * Description: 拦截器配置
 * <br />
 * CreateDate 2021-11-05 16:06
 *
 * @author yuyi
 **/
@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    @Value("#{'${auth.whiteList}'.split(',')}")
    private List<String> whiteList;

    /**
     * 鉴权模式
     **/
    @Value("${auth.authModel:1}")
    private int authModel;

    @Bean
    public AuthInterceptor authInterceptor() {
        return new AuthInterceptor();
    }

    @Bean
    public SimpleAuthInterceptor simpleAuthInterceptor() {
        return new SimpleAuthInterceptor();
    }

    @Bean
    public DevAuthInterceptor devAuthInterceptor() {
        return new DevAuthInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration ir;
        switch (authModel) {
            case AuthConstant.AUTH_MODEL_1:
                //最强拦截：白名单放行（传了token会自动获取用户id透传），否则拦截（没有token或没权限都会拦截）
                ir = registry.addInterceptor(authInterceptor()).addPathPatterns("/**");
                break;
            case AuthConstant.AUTH_MODEL_2:
                //简单拦截：白名单放行（传了token会自动获取用户id透传），否则拦截（没有token会拦截，不鉴权url请求权限）
                ir = registry.addInterceptor(simpleAuthInterceptor()).addPathPatterns("/**");
                break;
            case AuthConstant.AUTH_MODEL_3:
                //开发拦截：所有url放行（传了token会自动获取用户id透传），否则用户id使用配置中的固定用户
                ir = registry.addInterceptor(devAuthInterceptor()).addPathPatterns("/**");
                break;
            default:
                //默认不鉴权
                return;
        }
        if(ir != null){
            ir.excludePathPatterns(whiteList)
                    .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**");
        }
    }
}
