package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 用户组织信息(UserOrgan)传输对象类
 *
 * @author yuy336
 * @since 2022-01-12 15:00:02
 */
@ApiModel(value = "用户组织信息", description = "用户组织信息")
@Data
public class UserOrganDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = 587803490286287212L;
    
    @ApiModelProperty(value = "用户id")
    private String userId;
    
    @ApiModelProperty(value = "组织id")
    private String organId;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

	@ApiModelProperty(value = "组织id集合")
    private List<String> organIdList;
}

