package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 组织类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum OrganTypeEnum {

    GROUP(1, "集团"),
    COMPANY(2, "公司"),
    DEPARTMENT(3, "部门"),
    TEAM(4, "组");

    private int code;
    private String name;

    OrganTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static OrganTypeEnum getEnumByCode(int code) {
        for (OrganTypeEnum sys : OrganTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
