package com.cusc.nirvana.user.auth.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.*;

/**
 * Description: AccessToken hash对象
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "AccessToken hash对象", description = "AccessToken hash对象")
public class AccessTokenHashDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("刷新token")
    private String refresh;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("用户授权的作用域")
    private String scope;

    @ApiModelProperty("应用id")
    private String appId;

    @ApiModelProperty("租户编号")
    private String tenantNo;

	@ApiModelProperty("组织id")
	private String organId;

    public String getRefresh() {
        return refresh;
    }

    public void setRefresh(String refresh) {
        this.refresh = refresh;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

	public String getOrganId() {
		return organId;
	}

	public void setOrganId(String organId) {
		this.organId = organId;
	}

	@Override
    public String toString() {
        return "AccessTokenHashDTO{" +
                "refresh='" + refresh + '\'' +
                ", userId='" + userId + '\'' +
                ", scope='" + scope + '\'' +
                ", appId='" + appId + '\'' +
                ", tenantNo='" + tenantNo + '\'' +
                '}';
    }
}
