package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 组织机构(Organization)传输对象类
 *
 * @author yuy336
 * @since 2022-01-12 14:59:30
 */
@ApiModel(value = "组织机构", description = "组织机构")
@Data
public class OrganizationDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = -99323777495496194L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "组织场景 1 实名  2 运管")
    private String organScene;
    
    @ApiModelProperty(value = "组织编码")
    private String organCode;
    
    @ApiModelProperty(value = "组织姓名")
    private String organName;
    
    @ApiModelProperty(value = "组织类型:1 集团 2 公司 3部门 4 组")
    private Integer organType;
    
    @ApiModelProperty(value = "上级组织")
    private String parentId;
    
    @ApiModelProperty(value = "组织描述")
    private String comment;
    
    @ApiModelProperty(value = "外部id")
    private String thirdPartyId;
    
    @ApiModelProperty(value = "所属省")
    private String province;
    
    @ApiModelProperty(value = "所属市")
    private String city;
    
    @ApiModelProperty(value = "所属区县")
    private String district;
    
    @ApiModelProperty(value = "展示顺序，数字越大越靠前")
    private Integer displaySort;
    
    @ApiModelProperty(value = "状态： 0 禁用 1启用")
    private Integer status;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "业务类型，由业务系统定义。如车企、经销商等")
    private Integer bizType;

    @ApiModelProperty(value = "查询编码，记录当前组织的树形结构")
    private String queryCode;

	@ApiModelProperty(value = "统一社会信用代码")
	private String uniqueCode;

	@ApiModelProperty(value = "组织简称")
	private String organSimpleName;

	@ApiModelProperty(value = "管理员id")
	private String adminUserId;

	@ApiModelProperty(value = "管理员姓名")
	private String adminName;

	@ApiModelProperty(value = "管理员账号")
	private String adminAccount;

	@ApiModelProperty(value = "管理员手机号")
	private String adminPhone;

    @ApiModelProperty(value = "uuid集合信息")
    private List<String> uuidList;

    @ApiModelProperty(value = "用于区分走新老流程")
    private String type;

    @ApiModelProperty(value = "业务类型集合，由业务系统定义。如车企、经销商等")
    private List<Integer> bizTypeList;
}

