package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (Application)传输对象类
 *
 * @author yuy336
 * @since 2022-01-11 17:09:08
 */
@ApiModel(value = "应用管理数据传输对象", description = "应用管理数据传输对象")
@Data
public class ApplicationDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = -36413222636238414L;

    @ApiModelProperty(value = "应用编码")
    private String applicationCode;

    @ApiModelProperty(value = "应用名称")
    private String applicationName;

    @ApiModelProperty(value = "访问令牌有效期（秒）")
    private Integer accessTokenTerm;

    @ApiModelProperty(value = "token续期时间，单位秒，大于表示需求，小于等于0则不续期")
    private Integer renewalTokenTime;

    @ApiModelProperty(value = "刷新令牌有效期（秒）")
    private Integer refreshTokenTerm;

    @ApiModelProperty(value = "应用秘钥")
    private String appSecret;

    @ApiModelProperty(value = "是否限制单设备登录")
    private Integer isDeviceLogin;

    @ApiModelProperty(value = "是否打开url鉴权")
    private Integer openAuth;

    @ApiModelProperty(value = "是否强制修改密码")
    private Integer isForceChangePwd;

    @ApiModelProperty(value = "密码错误期限（秒）")
    private Integer pwsErrorLockTerm;

    @ApiModelProperty(value = "密码错误次数")
    private Integer pwsErrorLockNum;

    @ApiModelProperty(value = "密码错误锁定时长（秒）")
    private Integer pwsErrorLockTime;

    @ApiModelProperty(value = "短信发送总次数限制（天）")
    private Integer smsTotalLimit;

    @ApiModelProperty(value = "短信发送间隔限制（秒）")
    private Integer smsIntervalLimit;

    @ApiModelProperty(value = "短信签名code")
    private String smsSignatureCode;

    @ApiModelProperty(value = "短信平台key")
    private String smsPlatformKey;

    @ApiModelProperty(value = "状态： 0 禁用 1启用")
    private Integer status;
}

