package com.cusc.nirvana.user.auth.identification.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * Description: 手机号登录请求
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "手机号登录请求", description = "手机号登录请求")
@Data
public class MobileLoginReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "手机号", example = "130xxxxxxxx")
    private String phone;

    @ApiModelProperty(value = "验证码", example = "3456/sujd")
    private String captcha;

    @ApiModelProperty(value = "验证码失效时间（秒）")
    private Integer captchaExpire;

    @ApiModelProperty(value = "应用id", example = "1")
    private String applicationId;

    @ApiModelProperty(value = "租户编号", example = "1")
    private String tenantNo;

    @ApiModelProperty(value = "是否验证图形验证码 true 验证  false 不验证", example = "默认 false ")
    private boolean checkCaptchaImg;

    @ApiModelProperty(value = "图形验证码", example = "3456/sujd")
    private String captchaImage;

    @ApiModelProperty(value = "请求id", example = "c2d4819083cb40dba35bbe007779ba6a")
    private String requestId;

    @ApiModelProperty(value = "短信发送配置")
    private SmsSendConfig smsSendConfig;

    @ApiModelProperty(value = "用户类型，参考枚举：UserTypeEnum")
    private Integer userType;

    @ApiModelProperty(value = "用于区分是否需要跳过用户校验")
    private String loginType;
}
