package com.cusc.nirvana.user.auth.identification.dto;

import com.cusc.nirvana.user.auth.common.constants.CaptchaTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * Description: 验证码创建请求dto
 * <br />
 * CreateDate 2022-01-24 14:02:17
 *
 * @author yuyi
 **/
@ApiModel(value = "验证码创建请求dto", description = "验证码创建请求dto")
@Data
public class CaptchaCreateReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "验证码类型")
    private CaptchaTypeEnum captchaType;

    @ApiModelProperty(value = "验证码宽度")
    private int captchaWidth;

    @ApiModelProperty(value = "验证码高度")
    private int captchaHeight;

    @ApiModelProperty(value = "验证码长度")
    private int captchaLength;

}
