package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 用户资源关系(UserResource)传输对象类
 *
 * @author yuy336
 * @since 2022-01-19 13:41:24
 */
@ApiModel(value = "用户资源关系", description = "用户资源关系")
@Data
public class UserResourceDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = -52832421917906673L;
    
    @ApiModelProperty(value = "用户id")
    private String userId;
    
    @ApiModelProperty(value = "角色id")
    private String resourceId;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "应用id")
    private String applicationId;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "资源id集合")
    private List<String> resourceIdList;

    @ApiModelProperty(value = "用户id集合")
    private List<String> userIdList;
}

