package com.cusc.nirvana.user.eiam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * Description: 用户密码dto
 * <br />
 * CreateDate 2022-06-11 23:56:43
 *
 * @author yuyi
 **/
@ApiModel(value = "用户密码dto", description = "用户密码dto")
@Data
public class UserPasswordDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "密钥的请求id")
    private String requestId;

    @ApiModelProperty(value = "用户密码")
    private String password;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "短信发送配置")
    private SmsSendConfig smsSendConfig;

    @ApiModelProperty(value = "短信验证码，不为空则验证")
    private String smsCode;
}
