package com.cusc.nirvana.user.eiam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * <p>
 * 资源简单对象
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@ApiModel(value = "资源简单对象", description = "资源简单对象")
@Data
public class ResourceSimpleDTO implements Serializable {

    @ApiModelProperty(value = "资源id")
    private String uuid;

    @ApiModelProperty(value = "资源编码")
    private String resourceCode;

    @ApiModelProperty(value = "资源页面path，定位ui元素使用")
    private String resourceUiPath;

    @ApiModelProperty(value = "资源对应url")
    private String resourceUrl;

    @ApiModelProperty(value = "资源名称")
    private String resourceName;

    @ApiModelProperty(value = "展示顺序")
    private Integer displaySort;

    @ApiModelProperty(value = "父节点资源")
    private String parentId;

    @ApiModelProperty(value = "资源类型：0-菜单；1-页面元素；2-接口")
    private Integer resourceType;

    @ApiModelProperty(value = "关联应用")
    private String applicationId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
}
