package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * eiam数据操作历史(DataOperationLog)传输对象类
 *
 * @author yuy336
 * @since 2022-01-12 15:02:10
 */
@ApiModel(value = "eiam数据操作历史", description = "eiam数据操作历史")
@Data
public class DataOperationLogDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = 852999988879600691L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "业务数据主键")
    private String bizUuid;
    
    @ApiModelProperty(value = "数据库表名")
    private String dbTableName;
    
    @ApiModelProperty(value = "数据内容（修改之前的内容）")
    private String content;
    
    @ApiModelProperty(value = "操作事件：描述通过哪个功能来修改")
    private String optEvent;
    
    @ApiModelProperty(value = "${column.comment}")
    private String tenantNo;
}

