package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 租户业务场景枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum TenantBizzSceneEnum {

    COM(1, "统一运管场景"),
    RNR(2, "实名场景"),
    CLOUD(3, "云平台场景");

    private int code;
    private String name;

    TenantBizzSceneEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static TenantBizzSceneEnum getEnumByCode(int code) {
        for (TenantBizzSceneEnum sys : TenantBizzSceneEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
