package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 角色类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum RoleTypeEnum {

    PLATFORM_ADMIN(1, "平台管理员"),
    TENANT_ADMIN(2, "租户管理员"),
    AUDITOR(3, "审计员"),
    OTHER(4, "普通角色");

    private int code;
    private String name;

    RoleTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RoleTypeEnum getEnumByCode(int code) {
        for (RoleTypeEnum sys : RoleTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
