package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 角色场景枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum RoleSceneEnum {

    TENANT(1, "租户角色"),
    USER(2, "用户角色");

    private int code;
    private String name;

    RoleSceneEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RoleSceneEnum getEnumByCode(int code) {
        for (RoleSceneEnum sys : RoleSceneEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
