package com.cusc.nirvana.user.ciam.constants;

/**
 * Description: 公司类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum CommonStatusEnum {

    ENABLE(0, "禁用"),
    DISABLE(1, "启用");

    private int code;
    private String name;

    CommonStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CommonStatusEnum getEnumByCode(int code) {
        for (CommonStatusEnum sys : CommonStatusEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
