package com.cusc.nirvana.user.ciam.constants;

/**
 * Description: 公司类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum CommonDeleteEnum {

    NORMAL(0, "正常"),
    DELETED(1, "已删除");

    private int code;
    private String name;

    CommonDeleteEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CommonDeleteEnum getEnumByCode(int code) {
        for (CommonDeleteEnum sys : CommonDeleteEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
