package com.cusc.nirvana.user.auth.identification.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * Description: 用户登录响应信息
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "用户登录响应信息", description = "用户登录响应信息")
@Data
public class UserLoginResp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id", example = "e7486b176ea5447a9747856f53330220")
    private String userId;

    @ApiModelProperty(value = "昵称", example = "张三")
    private String nickName;

    @ApiModelProperty(value = "登录名", example = "xxx")
    private String loginName;

    @ApiModelProperty(value = "应用id", example = "1")
    private String appId;

    @ApiModelProperty(value = "租户编号", example = "1")
    private String tenantNo;
}
