package com.cusc.nirvana.user.auth.identification.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.*;

/**
 * Description: 用户token dto
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "oauth token对象", description = "oauth token对象")
public class Oauth2Token implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "访问token", example = "e7486b176ea5447a9747856f53330220")
    private String access_token;

    @ApiModelProperty(value = "token类型", example = "bearer")
    private String token_type;

    @ApiModelProperty(value = "刷新token", example = "9ff4aa6be3fa4ce5bc6330859b963025")
    private String refresh_token;

    @ApiModelProperty(value = "过期时间（秒）", example = "1000")
    private Integer expires_in;

    @ApiModelProperty(value = "用户授权的作用域", example = "ALL")
    private String scope;

    @ApiModelProperty(value = "用户信息", example = "用户信息")
    private UserLoginResp info;

    public String getAccess_token() {
        return access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String getToken_type() {
        return token_type;
    }

    public void setToken_type(String token_type) {
        this.token_type = token_type;
    }

    public String getRefresh_token() {
        return refresh_token;
    }

    public void setRefresh_token(String refresh_token) {
        this.refresh_token = refresh_token;
    }

    public Integer getExpires_in() {
        return expires_in;
    }

    public void setExpires_in(Integer expires_in) {
        this.expires_in = expires_in;
    }

    public UserLoginResp getInfo() {
        return info;
    }

    public void setInfo(UserLoginResp info) {
        this.info = info;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        return "UserToken{" +
                "access_token='" + access_token + '\'' +
                ", token_type='" + token_type + '\'' +
                ", refresh_token='" + refresh_token + '\'' +
                ", expires_in=" + expires_in +
                ", info=" + info +
                ", scope=" + scope +
                '}';
    }
}
